
IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CP_Liquido_Producto') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CP_Liquido_Producto
END
GO

CREATE PROCEDURE [dbo].[CP_Liquido_Producto](
     @pFechaDesde DATETIME
   , @pFechaHasta DATETIME
   , @pNro_Lote Varchar(20)
   , @pGenerarLiquidacion TINYINT
   , @pId_Proveedor INT
   )
AS
  CREATE TABLE #Trans (Id_Trans INT)

  DECLARE @Id_Producto Varchar(14)
  ,@Id_Proveedor Int
  ,@Razon_Social VarChar(100)
  ,@Cuit Varchar(13)
  ,@Id_Iva Char(3)
  ,@Id_Alias_Cta_Cont Int
  ,@Id_Cta_Contable_H Int
  ,@Porc_Comision_Prov Decimal(7,2) 
  ,@Importe Decimal(12,2) 
  ,@IMPORTE_CREDITO Decimal(12,2) 
  ,@ID_TIPO_CBTE CHAR(4) 
  ,@FECHA DATETIME
  ,@Imp_prod_siva  Decimal(12,2) 
  ,@TRANS INT
  ,@Id_Cliente_Externo VARCHAR(14)
  ,@Id_Cta_Banco INT
  ,@Id_Cliente INT
  ,@Plazo    INT
  ,@PORCENTAJE DECIMAL(12,2)
  ,@Descripcion_Producto VarChar(200)
  ,@CANTIDAD INT
  ,@Precio DECIMAL(12,2)
  ,@ErrorRetorno Int

  DECLARE @Respuesta Table (
     ErrorNumber    int,
	  ErrorSeverity  INT,
	  ErrorState     INT,
	  ErrorProcedure INT,
	  ErrorLine      INT, 
      ErrorMessage   VARCHAR(100)
	  )


  SET @FECHA = (SELECT CAST(GETDATE() AS DATE))


  BEGIN


  Select P.Id_PROVEEDOR,isnull(v.Plazo_Venc,0) PLAZO,isnull(v.Porc_Desc_Liquidacion,30) PORCENTAJE,SUM(I.Imp_Gravado*T.COMPROMETE_FACTURA) IMPORTE
	Into #Res_Cond_Vta from cbtes c, Cbtes_Cond_Vtas v, cbtes_tipos t, CBTES_ITEMS I, PRODUCTOS P
	where c.id_tipo_cbte = t.Id_Tipo_Cbte
	And P.Id_PROVEEDOR = @pId_Proveedor
	And t.Compromete_Factura in (1,-1)
	And c.id_cond_vta = v.Id_Cond_Vta 
	and c.Id_Estado_Cbte <> 3 
	AND c.Fecha >= @pFechaDesde
    AND c.Fecha <  @pFechaHasta + 1
	AND V.Porc_Desc_Liquidacion > 0 AND I.ID_TRANS = C.ID_TRANS
	AND I.Id_Producto = P.Id_Producto
	   GROUP BY P.Id_PROVEEDOR,v.Plazo_Venc,v.Porc_Desc_Liquidacion HAVING SUM(I.Imp_Gravado*T.COMPROMETE_FACTURA) <> 0
	   ORDER BY P.Id_PROVEEDOR

 IF @pGenerarLiquidacion = 0
    Select * from #Res_Cond_Vta

 IF @pGenerarLiquidacion = 1

   BEGIN
	   DECLARE CUR_GENERAR CURSOR FOR

	   Select * from #Res_Cond_Vta

	   OPEN CUR_GENERAR
	   FETCH NEXT FROM CUR_GENERAR INTO  @Id_Proveedor,@Plazo,@PORCENTAJE,@Importe
	   WHILE @@FETCH_STATUS = 0
	   BEGIN

     		DELETE #Trans
			IF @Id_Proveedor > 0
        		BEGIN
				   SET @ID_TIPO_CBTE = (select Valor_String from xParametros where setDatos= 1 and idParametro ='T_Cbte_NV_Liq_Prod')
			   --    SET @ID_TIPO_CBTE = 'NVLP'

				   SET @Razon_Social = (select Razon_Social from Proveedores where Id_Proveedor = @Id_Proveedor)
				   INSERT INTO #Trans
			    		EXEC @ErrorRetorno = dbo.CP_Cbtes_Cpra_Generar_Cabe @Id_Proveedor,@Razon_Social,@Importe,1,@FECHA,@ID_TIPO_CBTE,'',1,@Plazo,100,@trans OUTPUT
			       IF @ErrorRetorno <> 0
				      RETURN 1

				END


		  DECLARE CUR_GENERAR_DETALLE CURSOR FOR

		  Select I.ID_PRODUCTO,I.Descripcion_producto,I.Precio,SUM(I.Cantidad*T.COMPROMETE_FACTURA) CANTIDAD 
		  from cbtes c, Cbtes_Cond_Vtas v, cbtes_tipos t, CBTES_ITEMS I,  PRODUCTOS P
			where c.id_tipo_cbte = t.Id_Tipo_Cbte and t.Compromete_Factura in (1,-1) and c.id_cond_vta = v.Id_Cond_Vta 
			and c.Id_Estado_Cbte <> 3 
			AND c.Fecha >= @pFechaDesde
			AND c.Fecha <  @pFechaHasta + 1
			AND P.Id_PROVEEDOR = @Id_Proveedor
			AND v.Plazo_Venc = @PLAZO
			AND v.Porc_Desc_Liquidacion = @PORCENTAJE
			AND v.Porc_Desc_Liquidacion > 0 
			And I.Precio <> 0
			AND I.ID_TRANS = C.ID_TRANS
	 		AND I.Id_Producto = P.Id_Producto
			GROUP BY I.ID_PRODUCTO,I.Descripcion_producto,I.Precio

		  OPEN CUR_GENERAR_DETALLE
		  FETCH NEXT FROM CUR_GENERAR_DETALLE INTO  @Id_Producto,@Descripcion_Producto,@Precio,@Cantidad
	  
		  WHILE @@FETCH_STATUS = 0
			  BEGIN
					 IF @trans > 0
						BEGIN
							  SET @Id_Cliente = 0
							  SET @Id_Cta_Banco = 0

							  EXEC @ErrorRetorno = dbo.SP_CbteItem_Agr   @Id_Producto,@trans,@Cantidad,@Precio,@fecha,'',@Descripcion_Producto,@ID_Cliente,@Id_Cta_Banco
							  IF @ErrorRetorno <> 0
				                 RETURN 1
        				END  

			  FETCH NEXT FROM CUR_GENERAR_DETALLE INTO  @Id_Producto,@Descripcion_Producto,@Precio,@Cantidad
		 END  

		 SET @IMPORTE_CREDITO = (SELECT SUM(IMP_GRAVADO) FROM CBTES_ITEMS WHERE ID_TRANS = @TRANS ) * (@PORCENTAJE/100) 
		 SET @Id_Producto  = (select Valor_String from xParametros where setDatos= 1 and idParametro ='Id_Prod_Desc_NVLP')
		 SET @Descripcion_Producto = (SELECT DESCRIPCION_DETALLADA FROM PRODUCTOS WHERE ID_PRODUCTO = @Id_Producto ) + ' % ' +Cast(@PORCENTAJE AS VARCHAR(10))

		 EXEC @ErrorRetorno = dbo.SP_CbteItem_Agr   @Id_Producto,@trans,-1,@IMPORTE_CREDITO,@fecha,'',@Descripcion_Producto,@ID_Cliente,@Id_Cta_Banco
 	  	 IF @ErrorRetorno <> 0
			 RETURN 1 

         INSERT INTO @RESPUESTA 
		 EXEC @ErrorRetorno = dbo.CP_Cbtes_Cpra_Generar_Fin @Id_Proveedor,@Razon_Social,@Importe,1,@FECHA,@ID_TIPO_CBTE,'',1,10,100,@trans 
		 IF @ErrorRetorno <> 0
			 RETURN 1

         INSERT INTO @RESPUESTA 
         EXEC @ErrorRetorno = dbo.CP_Cbtes_Cpra_Generar_Asi @Trans
		 IF @ErrorRetorno <> 0
			 RETURN 1

         UPDATE Cbtes SET Id_Estado_Cbte =  1, Lote = @pNro_Lote WHERE ID_TRANS = @TRANS 

		 CLOSE CUR_GENERAR_DETALLE
		 DEALLOCATE CUR_GENERAR_DETALLE

		 FETCH NEXT FROM CUR_GENERAR INTO @Id_Proveedor,@Plazo,@PORCENTAJE,@Importe

	  END
	  CLOSE CUR_GENERAR
	  DEALLOCATE CUR_GENERAR 

	  Select * from #Res_Cond_Vta
	   
	END

END
  

--  exec CP_Liquido_Producto '20190306','20190308','nvlp3',1,123


